/* 
 *  AddAgentNote.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;

public class AddAgentNote extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(AddAgentNote.class);
    private final String note;

    public AddAgentNote(String interactionID, String note) {
        super(LOG, interactionID);
        this.note = note;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().addAgentNote(note);
        LOG.trace(methodName + "-");
        return null;
    }
}
